﻿<%@ Page Language="c#" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Place" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="System.IO" %>

<script runat="server">
    
    void dc_ContextLoad(Object sender, EventArgs e) {
        UmowaHistoria uh = (UmowaHistoria)dc[typeof(UmowaHistoria)];
        Umowa umowa = uh.Umowa;

        ReportHeader1["MIEJSCOWOSC"] = GetMiejscowosc(uh.Umowa.PracHistoria);
        DaneFirmy(umowa.PracHistoria);

        AgencjaPracyTymczasowejWdz wdz = umowa.Wydzial.AgencjaPT;
        if (wdz.WydziałKlienta != null)
            wdz = wdz.WydziałKlienta.AgencjaPT;
        Kontrahent knt = wdz.Pracodawca;

        Pracodawca.EditValue = knt != null ? knt.Nazwa : ".....................................";

        string siedziba = knt != null ? knt.Adres.ToString() : "....................................................................";
        Siedziba.EditValue = siedziba;

        string nip = knt != null ? knt.NIP : ".....................................";
        NIP.EditValue = nip;
    }

    string GetMiejscowosc(PracHistoria ph) {
        CoreModule core = CoreModule.GetInstance(dc);
        string miejscowosc = ReportHeader.GetPieczątka(dc).Adres.Miejscowosc;
        if (miejscowosc.Length == 0)
            miejscowosc = core.Config.Firma.AdresSiedziby.Miejscowosc;
        if (ph.Etat.Wydzial != null && ph.Etat.Wydzial.Oddzial != null) {
            OddzialFirmy of = ph.Etat.Wydzial.Oddzial;
            if (!string.IsNullOrEmpty(of.Adres.Miejscowosc)) miejscowosc = of.Adres.Miejscowosc;
        }                
        return miejscowosc;
    }

    void DaneFirmy(PracHistoria ph) {
		CoreModule core = CoreModule.GetInstance(dc);
        string nip = core.Config.Firma.Pieczątka.NIP;
        string krs = core.Config.Ogólne.TekstDoStopkiWydruku;
        string miejscowosc = core.Config.Firma.AdresSiedziby.Miejscowosc;
        string nazwa = core.Config.Firma.Pieczątka.Nazwa;
        string ulica = core.Config.Firma.AdresSiedziby.Ulica;
        string nrDomu = core.Config.Firma.AdresSiedziby.NrDomu;
        string nrLokalu = core.Config.Firma.AdresSiedziby.NrLokalu;
        string kodP = core.Config.Firma.AdresSiedziby.KodPocztowyS;
        if (ph.Etat.Wydzial != null && ph.Etat.Wydzial.Oddzial != null) {
            OddzialFirmy of = ph.Etat.Wydzial.Oddzial;
            if (!string.IsNullOrEmpty(of.Deklaracje.NIP)) nip = of.Deklaracje.NIP;
            if (!string.IsNullOrEmpty(of.Deklaracje.KRS)) krs = of.Deklaracje.KRS;
            if (!string.IsNullOrEmpty(of.Adres.Miejscowosc)) miejscowosc = of.Adres.Miejscowosc;
            if (!string.IsNullOrEmpty(of.Nazwa)) nazwa = of.Nazwa;
            if (!string.IsNullOrEmpty(of.Adres.Ulica)) ulica = of.Adres.Ulica;
            if (!string.IsNullOrEmpty(of.Adres.NrDomu)) nrDomu = of.Adres.NrDomu;
            if (!string.IsNullOrEmpty(of.Adres.NrLokalu)) nrLokalu = of.Adres.NrLokalu;
            if (!string.IsNullOrEmpty(of.Adres.KodPocztowyS)) kodP = of.Adres.KodPocztowyS;
        }
        PieczątkaKRS.EditValue = (krs.Length > 0) ? krs : ".............................................................................";
        PieczątkaMiejscowosc.EditValue = miejscowosc;
        PieczątkaNazwa.EditValue = nazwa;
        PieczątkaUlica.EditValue = ulica;
        PieczątkaNrDomu.EditValue = nrDomu;
        PieczątkaNrLokalu.EditValue = nrLokalu;
        PieczątkaKodPocztowyS.EditValue = kodP;
        NumerLokalu.Visible = (nrLokalu.Length > 0);
    }

</script>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Zaświadczenie</title> 
    <meta content="False" name="vs_showGrid" />
    <meta content="Microsoft Visual Studio 7.0" name="GENERATOR" />
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form id="UmowaODzieło" method="post" runat="server">
        <EA:DATACONTEXT id="dc" runat="server" OnContextLoad="dc_ContextLoad" TypeName="Soneta.Kadry.Umowa, Soneta.KadryPlace"></EA:DATACONTEXT>
		<cc1:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" 
            title="&lt;center&gt;Zaświadczenie&lt;/center&gt;|%MIEJSCOWOSC%, {0}" 
            DataMember0="Context.ActualDate.Actual"
            runat="server"></cc1:ReportHeader>
        <br />
        <font face="Tahoma" size="2">
            <p style="text-align:justify">
                <ea:datalabel id="PieczątkaNazwa" runat="server"></ea:datalabel>
                z siedzibą ul.
                <ea:datalabel id="PieczątkaUlica" runat="server" Bold="false"></ea:datalabel>
                <ea:datalabel id="PieczątkaNrDomu" runat="server" Bold="false"></ea:datalabel>
                <ea:Section ID="NumerLokalu" runat="server" Width="100%">
                    /<ea:datalabel id="PieczątkaNrLokalu" runat="server" Bold="false"></ea:datalabel>
                </ea:Section>
                <ea:datalabel id="PieczątkaKodPocztowyS" runat="server" Bold="false"></ea:datalabel>
                <ea:datalabel id="PieczątkaMiejscowosc" runat="server" Bold="false"></ea:datalabel>
                <ea:Section id="KRSSection" runat="server">
                    wpisanym/ą do rejestru przedsiębiorców przez
                    <ea:datalabel runat="server" ID="PieczątkaKRS" Bold="false"></ea:datalabel>
                </ea:Section>
                Agencja Zatrudnienia zaświadcza, że
                <ea:datalabel id="Datalabel34" runat="server" DataMember="PracHistoria.Nazwisko"></ea:datalabel>
                <ea:datalabel id="Datalabel35" runat="server" DataMember="PracHistoria.Imie"></ea:datalabel>
                <ea:DataLabel id="DataLabe51" runat="server" DataMember="PracHistoria.Plec" Bold="false">
                    <ValuesMap>
                        <ea:ValuesPair Key="Kobieta" Value="zamieszkała"></ea:ValuesPair>
                        <ea:ValuesPair Key="Mężczyzna" Value="zamieszkały"></ea:ValuesPair>
                    </ValuesMap>
                </ea:DataLabel>
                <ea:datalabel id="Datalabel36" runat="server" DataMember="PracHistoria.Adres" Bold="false"></ea:datalabel>,
                nr PESEL:
                <ea:datalabel id="Datalabel1" runat="server" DataMember="PracHistoria.PESEL" Bold="false"></ea:datalabel>
                <ea:DataLabel id="DataLabel2" runat="server" DataMember="PracHistoria.Plec" Bold="true">
                    <ValuesMap>
                        <ea:ValuesPair Key="Kobieta" Value="wykonywała"></ea:ValuesPair>
                        <ea:ValuesPair Key="Mężczyzna" Value="wykonywał"></ea:ValuesPair>
                    </ValuesMap>
                </ea:DataLabel>
                <b>pracę tymczasową na podstawie umowy prawa cywilnego:</b>
            </p>
            <p style="text-align:left">
                na rzecz Pracodawcy Użytkownika
                <ea:DataLabel ID="Pracodawca" runat="server"></ea:DataLabel>,
                z siedzibą
                <ea:DataLabel ID="Siedziba" runat="server"></ea:DataLabel>,
                NIP Pracodawcy Użytkownika:
                <ea:DataLabel ID="NIP" runat="server"></ea:DataLabel>
                w okresie od dnia
                <ea:DataLabel ID="Datalabel43" runat="server" DataMember="Okres.From"></ea:DataLabel>
                do dnia
                <ea:DataLabel ID="Datalabel44" runat="server" DataMember="Okres.To">
                    <ValuesMap>
                        <ea:ValuesPair Key="(max)" Value=". . . . . . . . . ." />
                    </ValuesMap>
                </ea:DataLabel>.
            </p>
        </font>
        <br /><br /><br /><br />
		<font face="Tahoma" size="2">
            <p align="right">
                ...........................................<br />
                Podpis&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            </p>
        </font>
        <ea:SectionMarker ID="SectionMarker8" runat="server" SectionType="Footer"></ea:SectionMarker>
	</form>
</body>
</html>
